program FindRoot;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  Tools1v2 in 'Tools1v2.pas',
  AnsiTo866 in 'AnsiTo866.pas',
  DialogFindRoot in 'DialogFindRoot.pas',
  MyMath1V2 in 'MyMath1V2.pas';

// =========================================================
//     
// =========================================================

const MaxNumArray = 15;
//  
var XArray   : array [0..MaxNumArray] of double;

// =========================================================
//     
var
  F0        : double;  //    
  XB        : double;  //     
  XE        : double;  //     
  CodeEndF0 : byte;    // 0 -   
  CodEndXb  : byte;    // 0 -    
  CodEndXe  : byte;    // 0 -    

// =========================================================
//   
// =========================================================
//   
var CmdChar  : char;

// =========================================================
//       
// =========================================================
//      
procedure ShowMenu();
begin
WriteLn;
WriteLnRus (' /COMMAND MENU:'); WriteLn;
WriteLnRus ('H - /Help');
WriteLnRus ('--------    -------------');
WriteLnRus ('V -    ');
WriteLnRus ('Z -    ');
WriteLnRus ('P -      Ind');
WriteLnRus ('R -    ');
WriteLnRus ('E -   EXP - ');
WriteLnRus ('S -   SIN - ');
WriteLnRus ('C -   COS - ');
WriteLnRus ('I -   SI - ');
WriteLnRus ('------      ------');
WriteLnRus ('W -     ');
WriteLnRus ('------------------------------------------------------');
WriteLnRus ('G -   ');
WriteLnRus ('Q - /Quit');
WriteLn;
end;

// =========================================================
//    
// =========================================================

// ---------------------------------------------------------
//    (    
// )    
function FindXRoot(): boolean;
//  FindXRoot
const  DeltaF   = 1E-10;   //     
const  FindNumb = 64;      // .     
//   FindXRoot
var    FB     : double;    //    B
       FE     : double;    //    E
       FUP    : boolean;   //   - True,  - False
       Found  : boolean;   //  () " "
       CNumb  : integer;   //   ()
       NewX   : double;    //    -   ()
       NewF   : double;    //   F -   ()
//   FindXRoot
procedure ReportFindXRoot();
begin
     //     
     WriteLnRus(' ! ');
     WriteLnRus('    =  ' + IntToStr(CNumb));
     WriteLnRus('    =  ' + FloatToStr(NewX));
     WriteLnRus('  =  ' + FloatToStr(NewF));
     WriteLnRus('     =  ' + FloatToStr(F0));
     WriteLnRus('   =  ' + FloatToStr(NewF-F0));
     WriteLn;
end; // of ReportFindXRoot()
begin
  //    
  FB := PPolynom(XArray, XB);
  FE := PPolynom(XArray, XE);
  Found := False;           //  " "
  CNumb := 0;               //   ()
   //        ?
  if (Abs(FB - F0) <= DeltaF) or (Abs(FE - F0) <= DeltaF)
  then begin
     //  
     Found := true;
     if (Abs(FB - F0) <= DeltaF)
     then begin
        //   Delta 
        NewX := XB;
        NewF := FB;
     end
     else begin
        //   Delta 
        NewX := XE;
        NewF := FE;
     end;
     //     
     ReportFindXRoot();
  end
  // ,   ,  
  else begin
      //    -   
      FUP := False;
      if FE > FB then FUP := True;
      //  
      repeat
         //       XB..XE
         NewX := XB + ( XE - XB )/2;
         NewF := PPolynom( XArray, NewX );
         if Abs(NewF - F0) <= DeltaF
         then begin
            Found := True;    //  
            //     
            ReportFindXRoot();
         end
         else begin
            //    
            if FUP
            then begin
               //   
               if F0 > NewF
               then XB := NewX
               else XE := NewX;
            end
            else begin
               //   
               if F0 < NewF
               then XB := NewX
               else XE := NewX;
            end;
         end; {if Abs(NewF - F0) <= DeltaF}
         CNumb := CNumb + 1;
      until Found or (CNumb > FindNumb)
  end; {if (FB = F0) or (FE = F0)}

  if not Found
  then begin
     //  
     WriteLnRus(' ! ');
     WriteLnRus('    = ' + IntToStr(CNumb));
     WriteLn;
  end;
  Result := Found;
end;

// =========================================================
//    
// =========================================================

// ---------------------------------------------------------
//    
procedure InitCodeEnd ();
begin
   CodeEndF0 := 1;  //  =     
   CodEndXb  := 1;  //  =     
   CodEndXe  := 1;  //  =     
end;

// ---------------------------------------------------------
// .       
procedure InputSourceData ();
begin
 //    
 InitCodeEnd ();
 //    
 CodeEndF0 := InputFloatValue ('    : ', F0);
 WriteLn;
 if (CodeEndF0 = 0)
 then begin
   //  ,       .
   CodEndXb := FindLowX (XArray, F0, XB);
   if (CodEndXb = 0)
   then begin
      //  ,        .
      CodEndXe := FindHighX (XArray, F0, XE);
   end;
 end;
end;

// ---------------------------------------------------------
// .      
//       .
procedure RunFindXRoot();
var Ind : integer;
    Sum : double;
begin
  // ,       
  Sum := 0;
  for Ind := Low(XArray) to High(XArray)
  do begin
    Sum := Sum + Abs(XArray[Ind]);
  end;
  //    (Sum > 0),    
  if Sum > 0
  then begin
     if CodeEndF0 + CodEndXb + CodEndXe > 0
     then begin
        WriteLnRus('   ');
        WriteLnRus('    ');
        WriteLn;
     end
     else FindXRoot(); //   
  end
  else begin
    WriteLnRus('   ');
    WriteLnRus('   ');
    WriteLn;
  end;
end;

// =========================================================
//    ( )
// =========================================================
begin
  { TODO -oUser -cConsole Main : Insert code here }
// 
  WriteLn    ('==============================================');
  WriteLnRus ('     ');
  WriteLn    ('==============================================');
  InitCodeEnd ();  //    
  ShowMenu;
  repeat
    WriteRus (' /IMPUT COMMAND : ');
    ReadLn(CmdChar);
    CmdChar:=UpCase(CmdChar);
    case CmdChar of
    'H': begin ShowMenu(); end;
    'V': begin ShowArray(XArray); end;
    'P': begin
           InitCodeEnd ();        //    
           DWriteToArray(XArray); //   
         end;
    'R': begin
           InitCodeEnd ();        //    
           //   
           WriteRandomToArray(0.123, 20, XArray);
           //      
           SortArray('D', XArray);
           ShowArray(XArray);     //    
         end;
    'E':  begin
           InitCodeEnd ();        //    
           TaylorCoeffToArray('E', XArray);    // EXP - 
           ShowArray(XArray);     //    
         end;
    'S':  begin
           InitCodeEnd ();        //    
           TaylorCoeffToArray('S', XArray);    // SIN - 
           ShowArray(XArray);     //    
         end;
    'C':  begin
           InitCodeEnd ();        //    
           TaylorCoeffToArray('C', XArray);    // COS - 
           ShowArray(XArray);     //    
         end;
    'I':  begin
           InitCodeEnd ();        //    
           TaylorCoeffToArray('I', XArray);    // Si - 
           ShowArray(XArray);     //    
         end;
    'Z': begin
           InitCodeEnd ();        //    
           EraseRqArray (XArray); //   
           ShowArray(XArray);     //    
         end;
    'W': begin
           InputSourceData ();    //   
         end;
    'G': begin
            RunFindXRoot();       //   
         end;
    else begin
        WriteLnRus(#09 + '( )/ERROR(Unknown command)');
         end;
    end;
  until ('Q' = CmdChar);

end.


